<?php
    /**
     * Plugin Name: Sakamari Site Manager
     * Description: Sakamari is the Site Manager for Closebee, Bilzee and Tallyplug
     * Author: Sakamari Technology Team
     * Author URI: https://closebee.com
     * Version: 5.0.0.0
     * Plugin URI: https://sakamari.closebee.com
     */
    
    global $org, $profile, $user, $billing_user, $bad, $post_args;
    $billing_user = (object) array();
    $bad = (object) array();
    $post_args = array(
        'timeout' => '5', 
        'redirection' => '5', 
        'httpversion' => '1.0', 
        'blocking' => true, 
        'headers' => array('Content-Type' => 'application/json; charset=utf-8'), 
        'cookies' => array(),
        'method'  => 'POST',
        'data_format' => 'body'
    );
    
    $plugin_dir = plugin_dir_path( __FILE__);
    $pluginlog = plugin_dir_path(__FILE__).'sakamari-error.log';
    $plugin_dir_name = "";
    $cred_file = $plugin_dir."credentials.json";
    
    require_once $plugin_dir."includes/SakamariPluginActivator.php";
    require_once $plugin_dir."includes/SakamariPluginDeactivator.php";
    
    function sakamari_json_basic_auth_handler($user) {
        if (!empty($user)) {
            return $user;
        }
        if(!isset($_SERVER['PHP_AUTH_USER'])) {
            return $user;
        }
        $username = $_SERVER['PHP_AUTH_USER'];
        $password = $_SERVER['PHP_AUTH_PW'];
        remove_filter( 'determine_current_user', 'sakamari_json_basic_auth_handler', 20);
        $user = wp_authenticate($username, $password);
        add_filter( 'determine_current_user', 'sakamari_json_basic_auth_handler', 20);
        if ( is_wp_error($user)) {
            return null;
        }
        return $user->ID;
    }
    
    function sakamari_json_basic_auth_error($error) {
        if (!empty($error)) {
            return $error;
        }
        global $wp_json_basic_auth_error;
        return $wp_json_basic_auth_error;
    }
    
    function sakamari_plugin_activate(){
        global $plugin_dir_name;
        $dr = plugin_basename(__FILE__);
        $drarr = explode('/', $dr);
        $plugin_dir_name = $drarr[0];
        SakamariPluginActivator::activate(get_site_url());
    }

    function sakamari_plugin_deactivate(){
        SakamariPluginDeactivator::deactivate(get_site_url());
    }
    
    function sakamari_plugin_settings() {
        global $post_args, $plugin_dir, $plugin_dir_name, $pluginlog;
        global $org, $profile, $user, $cred_file;
        
        add_action('wp_enqueue_scripts', "load_style_dependencies");
        add_action('wp_enqueue_scripts', "load_script_dependencies");
        include($plugin_dir."includes/ui/settings/common-header.php");
        
        $out = "";
        error_log("Loading credentials from [$cred_file]".PHP_EOL, 3, $pluginlog);
        if(file_exists($cred_file)){
            $out = file_get_contents($cred_file);
        }
        if($out != ""){
            error_log("Loaded credentials [$cred_file]".PHP_EOL, 3, $pluginlog);
            $cred = json_decode($out);
            $org = $cred->org;
            $profile = $cred->profile;
            $user = $cred->user;
            include($plugin_dir."includes/ui/settings/app-integrated.php");
        }else {
            error_log("Failed loading credentials [$cred_file]".PHP_EOL, 3, $pluginlog);
            include($plugin_dir."includes/ui/settings/attach-token.php");
        }
        include($plugin_dir."includes/ui/settings/common-footer.php");
    }
    
    function handle_submit_sakamari_registration_form(){
        global $post_args, $pluginlog, $plugin_dir;
        global $org, $profile, $user, $cred_file;
        add_action('wp_enqueue_scripts', "load_style_dependencies");
        add_action('wp_enqueue_scripts', "load_script_dependencies");
        include($plugin_dir."includes/ui/settings/common-header.php");
        error_log("Registration form token [".$_POST['authtoken']."]".PHP_EOL, 3, $pluginlog);
        if(isset($_POST['authtoken'])){
            $token = $_POST['authtoken'];
            $rdata = (object) array('t' => $token);
            error_log("Fetching biz details using [".json_encode($rdata)."]".PHP_EOL, 3, $pluginlog);
            $post_args['body'] = json_encode($rdata);
            $out = wp_remote_post('https://sitexapi.pearnode.com/extn/org/bizt.php', $post_args);
            $robj = (object) $out;
            error_log("Bizload response [".json_encode($robj)."]".PHP_EOL, 3, $pluginlog);
            if(isset($robj->body)){
                $resp = json_decode($robj->body);
                error_log("Response data [".json_encode($resp)."]".PHP_EOL, 3, $pluginlog);
                if(isset($resp->org)){
                    file_put_contents($cred_file, $robj->body);
                    $rorg = $resp->org;
                    $rprofile = $resp->profile;
                    $srdata = (object) array('oc' => $rorg->code, 'pc' => $rprofile->code);
                    $site = (object) array('url' => get_site_url());
                    $srdata->site = $site;
                    $spost_args['body'] = json_encode($srdata);
                    
                    $sout = wp_remote_post('https://sitexapi.pearnode.com/api/org/site/create.php', $spost_args);
                    $srobj = (object) $sout;
                    $sbody = $srobj->body;
                    error_log("SiteRegistration response [$sbody]".PHP_EOL, 3, $pluginlog);
                    $ssite = json_decode($sbody);
                    if(isset($ssite->id) && ($ssite->id != -1)){
                        wp_redirect('admin.php?page=sakamari-plugin-page-woocommerce');
                    }else {
                        include($plugin_dir."includes/ui/settings/siteregistration-failed.php");
                    }
                }else {
                    include($plugin_dir."includes/ui/settings/creds-incorrect.php");
                }
            }else {
                include($plugin_dir."includes/ui/settings/bizload-failed.php");
            }
        }
        include($plugin_dir."includes/ui/settings/common-footer.php");
    }
    
    function handle_submit_sakamari_navigation_form(){
        add_action('wp_enqueue_scripts', "load_style_dependencies");
        add_action('wp_enqueue_scripts', "load_script_dependencies");
        if(isset($_POST['navslug'])){
            $slug = $_POST['navslug'];
            exit(wp_redirect("admin.php?page=$slug"));
        }
    }
    
    function sakamari_plugin_page_woocommerce() {
        global $post_args, $plugin_dir, $plugin_dir_name, $pluginlog;
        global $org, $profile, $user, $cred_file;
        add_action('wp_enqueue_scripts', "load_style_dependencies");
        add_action('wp_enqueue_scripts', "load_script_dependencies");
        $out = "";
        if(file_exists($cred_file)){
            $out = file_get_contents($cred_file);
        }
        error_log("Credential file out [$out]".PHP_EOL, 3, $pluginlog);
        if($out != ""){
            $cred = json_decode($out);
            if(isset($cred->org)){
                $org = $cred->org;
                $profile = $cred->profile;
                $user = $cred->user;
                
                $rdata = array('oc' => $org->code, 'pc' => $profile->code, 'surl' => get_site_url());
                error_log("Loading site with [".json_encode($rdata)."]".PHP_EOL, 3, $pluginlog);
                $post_args['body'] = json_encode($rdata);
                $out = wp_remote_post('https://sitexapi.pearnode.com/sakamari/details_url.php', $post_args);
                $robj = (object) $out;
                $body = $robj->body;
                $site = json_decode($body);
                error_log("Site load out [".json_encode($site)."]".PHP_EOL, 3, $pluginlog);
                if(isset($site->id)){
                    $wc_consumer_key = "";
                    $wc_consumer_secret = "";
                    if(isset($site->config)){
                        $sconfig = $site->config;
                        if(isset($sconfig->commerce)){
                            if($sconfig->commerce == "woocommerce"){
                                if(isset($sconfig->woocommerce)){
                                    $wc_consumer_key = $sconfig->woocommerce->woocommerce_consumer_key;
                                    $wc_consumer_secret = $sconfig->woocommerce->woocommerce_consumer_secret;
                                }
                            }
                        }
                    }
                    $dr = plugin_basename(__FILE__);
                    $drarr = explode('/', $dr);
                    $plugin_dir_name = $drarr[0];
                    include($plugin_dir."includes/ui/woocommerce/woocommerce.php");
                }else {
                    include($plugin_dir."includes/ui/settings/siteload-failed.php");
                }
            }else {
                include($plugin_dir."includes/ui/settings/creds-incorrect.php");
            }
        }else {
            exit(wp_redirect('admin.php?page=sakamari-plugin-settings'));
        }
    }

    function sakamari_woocommerce_init($params){
        global $org, $profile;
        add_action('wp_enqueue_scripts', "load_functional_dependencies");
        add_action('woocommerce_before_checkout_form', 'sakamari_before_checkout_form', 10, 1);
        add_filter('woocommerce_checkout_coupon_message', 'sakamari_checkout_coupon_message', 20, 1);
        add_filter('woocommerce_checkout_get_value', 'sakamari_checkout_fields', 10, 2 );
        add_filter('woocommerce_enable_order_notes_field', '__return_false', 9999);
        add_filter('woocommerce_thankyou_order_received_text', 'sakamari_thankyou_order_received_text', 10, 2);
        add_action('woocommerce_order_status_changed', 'sakamari_order_status_changed', 999, 4);
        add_filter('woocommerce_checkout_fields', 'sakamari_set_checkout_field_input_value_default' );
        add_filter('posts_where', 'sakamari_hide_private_products');
    }
    
    function sakamari_hide_private_products( $where ) {
        if ( is_admin() ) return $where;
        global $wpdb;
        return " $where AND {$wpdb->posts}.post_status != 'private' ";
    }
    
    function sakamari_checkout_coupon_message($notice) {
        return $notice."<br/>Address Book ? <a href='#' id='autofill_address'><b>Choose your address / add new</b></a>";
    }; 
    
    function sakamari_before_checkout_form($wccm_autocreate_account) {
        global $billing_user, $bad;
        if(isset($_GET['uaid'])){
            $uaid = $_GET['uaid'];
            $rdata = array('uadid' => $uaid);
            $post_args['body'] = json_encode($rdata);
            $out = wp_remote_post('https://sitexapi.pearnode.com/api/user/address/idx.php', $post_args);
            $robj = (object) $out;
            $body = $robj->body;
            $bad = json_decode($body);
            $_SESSION['uaid'] = $bad->id;
            
            $rdata = array('uid' => $bad->user_ref);
            $post_args['body'] = json_encode($rdata);
            $out = wp_remote_post('https://sitexapi.pearnode.com/api/user/self/details_id.php', $post_args);
            $robj = (object) $out;
            $body = $robj->body;
            $billing_user = json_decode($body);
            $_SESSION['uid'] = $billing_user->id;
            $_SESSION['user_email'] = $billing_user->login_id;
        }else {
            if(isset($_GET['uid'])){
                $uid = $_GET['uid'];
                $rdata = array('id' => $uid);
                $post_args['body'] = json_encode($rdata);
                $out = wp_remote_post('https://sitexapi.pearnode.com/api/user/self/details_id.php', $post_args);
                $robj = (object) $out;
                $body = $robj->body;
                $billing_user = json_decode($body);
            }
        }
    }; 
    
    function sakamari_checkout_fields( $value, $input = '') {
        global $billing_user, $bad;
        if(isset($bad->id)){
            $checkout_fields = array(
                'billing_first_name'    => $bad->first_name,
                'billing_last_name'     => $bad->last_name,
                'billing_country'       => $bad->country_code,
                'billing_address_1'     => $bad->address_line1,
                'billing_address_2'     => $bad->address_line2,
                'billing_city'          => $bad->city,
                'billing_state'         => $bad->state,
                'billing_postcode'      => $bad->zip,
                'billing_phone'         => $bad->mob,
                'billing_email'         => $bad->email,
                'shipping_first_name'   => $bad->first_name,
                'shipping_last_name'    => $bad->last_name,
                'shipping_country'      => $bad->country_code,
                'shipping_address_1'    => $bad->address_line1,
                'shipping_address_2'    => $bad->address_line2,
                'shipping_city'         => $bad->city,
                'shipping_state'        => $bad->state,
                'shipping_postcode'     => $bad->zip,
            );
            error_log("Checkout fields [".json_encode($checkout_fields)."]");
            if(isset($checkout_fields[$input])){
                if($input == "billing_state"){
                    $statemap = WC()->countries->get_states($bad->country_code);
                    foreach ($statemap as $skey => $svalue) {
                        if($svalue == $bad->state){
                            $value = $skey;
                        }
                    }
                }else {
                    $value = $checkout_fields[$input];
                }
            }
        }
        return $value;
    }
    
    function sakamari_set_checkout_field_input_value_default($fields){
        unset($fields['billing']['billing_company']);
        return $fields;
    }
    
    function sakamari_thankyou_order_received_text($str, $order) {
        if (is_user_logged_in()) return $str;
        $order_email = $order->get_billing_email();
        $email = email_exists($order_email);
        $user = username_exists($order_email);
        if ($user == false && $email == false) {
            $link = get_permalink( get_option( 'woocommerce_myaccount_page_id'));
            $format_link = '<a href="' . $link . '">logged in</a>';
            $str .= sprintf( __( ' An account has been automatically created for you and you are now %s. You will receive an email about this.', 'woocommerce'), $format_link);
        }
        return $str;
    }
 
    function sakamari_order_status_changed($order_id, $old_status, $new_status, $order){
        global $post_args, $billing_user, $bad;
        global $org, $profile;
        if($new_status == "processing"){
            updateOrderWithMeta($order_id);
            $rdata = (object) array('surl' => get_site_url(), 'ch_odid' => $order_id, 'uid' => $billing_user->id, 'uaid' => $bad->id);
            $nb_post_args = $post_args;
            $nb_post_args['blocking'] = false;
            $ojson = json_encode($rdata);
            $nb_post_args['body'] = $ojson;
            wp_remote_post('https://sitexapi.pearnode.com/sakamari/integ/woocommerce/order/created.php', $nb_post_args);
        }
    }
    
    function updateOrderWithMeta($order_id) {
        global $billing_user, $bad;
        global $post_args, $plugin_dir, $plugin_dir_name;
        global $org, $profile, $user, $cred_file;
        $uobj = (object) array('subs_type', 'open');
        $uai = (object) array();
        
        $uid = -1;
        $user_email = "";
        if(isset($_SESSION['uid'])){
            $uid = $_SESSION['uid'];
            $user_email = $_SESSION['user_email'];
            $uobj->id = $uid;
        }
        $billing_user->id = $uid;
        
        $uaid = -1;
        if(isset($_SESSION['uaid'])){
            $uaid = $_SESSION['uaid'];
            $uai->id = $uaid;
        }
        $bad->id = $uaid;
        
        $order = wc_get_order($order_id);
        if($uid == -1){
            $user_email = $order->get_billing_email();
        }
        
        $uai->address_line1 = $order->get_billing_address_1();
        $uai->address_line2 = $order->get_billing_address_2();
        if(!trim($uai->address_line2) == ""){
            $uai->address = $uai->address_line1." , ".$uai->address_line2;
        }else {
            $uai->address = $uai->address_line1;
        }
        $uai->city = $order->get_billing_city();
        $uai->country_name = $order->get_billing_country();
        $uai->country = $order->get_billing_country();
        $uai->zip = $order->get_billing_postcode();
        $uai->state_name = $order->get_billing_state();
        $uai->state = $order->get_billing_state();
        $uai->mob = $order->get_billing_phone();
        $uai->email = $order->get_billing_email();
        $first_name = $order->get_billing_first_name();
        $last_name = $order->get_billing_last_name();
        $uai->name = $first_name." ".$last_name;
        
        if (!is_user_logged_in()){
            $uobj->login_id = $user_email;
            $email = email_exists($user_email);
            $user = username_exists($user_email);
            if ($user == false && $email == false) {
                $random_password = wp_generate_password();
                $role = 'customer';
                
                $userx = wp_insert_user(array('user_email' => $user_email, 'user_login' => $user_email,
                    'user_pass' => $random_password, 'first_name' => $first_name, 'last_name' => $last_name,
                    'role' => $role));
                
                $uobj->full_name = $first_name." ".$last_name;
                $uobj->mobile_no = $order->get_billing_phone();
                $uobj->password = $random_password;
                
                update_user_meta($userx, 'billing_address_1', $uai->address_line1);
                update_user_meta($userx, 'billing_city', $uai->city);
                update_user_meta($userx, 'billing_company', $order->get_billing_company());
                update_user_meta($userx, 'billing_country', $uai->country);
                update_user_meta($userx, 'billing_email', $order->get_billing_email());
                update_user_meta($userx, 'billing_first_name', $first_name);
                update_user_meta($userx, 'billing_last_name',  $last_name);
                update_user_meta($userx, 'billing_phone', $uobj->mobile_no);
                update_user_meta($userx, 'billing_postcode', $uai->zip);
                update_user_meta($userx, 'billing_state', $uai->state);
                
                update_user_meta($userx, 'shipping_address_1', $order->get_shipping_address_1());
                update_user_meta($userx, 'shipping_city', $order->get_shipping_city());
                update_user_meta($userx, 'shipping_company', $order->get_shipping_company());
                update_user_meta($userx, 'shipping_country', $order->get_shipping_country());
                update_user_meta($userx, 'shipping_first_name', $order->get_shipping_first_name());
                update_user_meta($userx, 'shipping_last_name', $order->get_shipping_last_name());
                update_user_meta($userx, 'shipping_method', $order->get_shipping_method());
                update_user_meta($userx, 'shipping_postcode', $order->get_shipping_postcode());
                update_user_meta($userx, 'shipping_state', $order->get_shipping_state());
                
                wc_update_new_customer_past_orders($userx);
                wp_set_current_user($userx);
                wp_set_auth_cookie($userx);
            }else {
                $user = get_user_by('email', $user_email);
                $uobj->login_id = $user_email;
                $uobj->full_name = $user->user_firstname." ".$user->user_lastname;
                $uobj->mobile_no = get_user_meta($user->ID, 'user_phone' , true);
            }
        }else {
            $cuser = (object) wp_get_current_user();
            $uobj->login_id = $cuser->user_email;
            $uobj->full_name =  $cuser->user_firstname." ".$cuser->user_lastname ;
            $uobj->mobile_no = get_user_meta($cuser->ID,'user_phone',true);
        }
        if(trim($order->get_shipping_address_1()) == ""){
            $order->set_shipping_address_1($order->get_billing_address_1());
            $order->set_shipping_city($order->get_billing_city());
            $order->set_shipping_company($order->get_billing_company());
            $order->set_shipping_country($order->get_billing_country());
            $order->set_shipping_first_name($order->get_billing_first_name());
            $order->set_shipping_last_name($order->get_billing_last_name());
            $order->set_shipping_postcode($order->get_billing_postcode());
            $order->set_shipping_state($order->get_billing_state());
            $order->set_shipping_phone($order->get_billing_phone());
        }
        $order->save();

        if($billing_user->id == -1){
            $uobj->ai = $uai;
            $rdata = (object) array('user' => $uobj, 'prefer' => 'email');
            $nb_post_args = $post_args;
            $nb_post_args['blocking'] = true;
            $nb_post_args['body'] = json_encode($rdata);
            $out = wp_remote_post('https://sitexapi.pearnode.com/api/user/self/createxy.php', $nb_post_args);
            $robj = (object) $out;
            $body = $robj->body;
            $billing_user = json_decode($body);
            $bad = $billing_user->ai;
            unset($billing_user->ai);
        }else {
            $rdata = (object) array('id' => $billing_user->id, 'aid' => $bad->id);
            $nb_post_args = $post_args;
            $nb_post_args['blocking'] = true;
            $nb_post_args['body'] = json_encode($rdata);
            $out = wp_remote_post('https://sitexapi.pearnode.com/api/user/self/details_id.php', $nb_post_args);
            $robj = (object) $out;
            $body = $robj->body;
            $billing_user = json_decode($body);
            $bad = $billing_user->ai;
            unset($billing_user->ai);
        }
    }
    
    function sakamari_do_admin_init(){
		add_menu_page('Sakamari', 'Sakamari', 'manage_options', 'sakamari-plugin-settings', 'sakamari_plugin_settings', 'dashicons-superhero', 5);
		add_submenu_page('sakamari-plugin-settings', 'Sakamari Settings', 'Settings', 'manage_options', 'sakamari-plugin-settings', 'sakamari_plugin_settings');
		add_submenu_page('sakamari-plugin-settings', 'Sakamari Plugin Woocommerce', 'Woo Config', 'manage_options', 'sakamari-plugin-page-woocommerce', 
		    'sakamari_plugin_page_woocommerce');
		if (get_option('my_plugin_do_activation_redirect', false)) {
		    delete_option('my_plugin_do_activation_redirect');
		    wp_redirect('admin.php?page=sakamari-plugin-settings');
		}
    }
 
    function load_style_dependencies(){
        wp_enqueue_style('sakamari-font-awsome', plugins_url('includes/assets/css/fontawsome-6.0.0-all-min.css', __FILE__));
        wp_enqueue_style('sakamari-bootstrap-4.3.1', plugins_url('includes/assets/css/bootstrap-4.6.1.min.css', __FILE__));
        wp_enqueue_style('sakamari-nprogress', plugins_url('includes/assets/css/nprogress.css', __FILE__));
    }
    
    function load_script_dependencies(){
        wp_enqueue_script('sakamari-jquery', plugins_url('includes/assets/js/jquery-1.12.4.min.js', __FILE__));
        wp_enqueue_script('sakamari-bootstrap', plugins_url('includes/assets/js/bootstrap-4.6.1.min.js', __FILE__));
        wp_enqueue_script('sakamari-nprogress', plugins_url('includes/assets/js/nprogress.js', __FILE__));
        wp_enqueue_script('sakamari-mustache', plugins_url('includes/assets/js/mustache.min.js', __FILE__));
        wp_enqueue_script('sakamari-currency-formatter', plugins_url('includes/assets/js/currency-formatter-2.0.0.min.js', __FILE__));
        wp_enqueue_script('sakamari-sweetalert', plugins_url('includes/assets/js/sweetalert-2.9.17.min.js', __FILE__));
        wp_enqueue_script('sakamari-commons-util', plugins_url('includes/assets/js/pearnode-commons-util.js', __FILE__));
    }
    
    function load_functional_dependencies(){
        wp_enqueue_script('sakamari-widget-handler', plugins_url('includes/assets/js/widget-handler.js', __FILE__));
        wp_enqueue_script('sakamari-track-handler', plugins_url('includes/assets/js/track-handler.js', __FILE__));
    }
    
    register_activation_hook( __FILE__, 'sakamari_plugin_activate');
    register_deactivation_hook( __FILE__, 'sakamari_plugin_deactivate');
    
    function sakamari_register_extra_order_status() {
        register_post_status('wc-eos-submitted', array('label'=> 'Submitted', 'public' => true, 'show_in_admin_status_list' => true, 'show_in_admin_all_list'=> true, 'exclude_from_search'=> false) );
        register_post_status('wc-eos-paid', array('label'=> 'Paid', 'public' => true, 'show_in_admin_status_list' => true, 'show_in_admin_all_list'=> true, 'exclude_from_search'=> false));
        register_post_status('wc-eos-violated', array('label'=> 'Violated', 'public' => true, 'show_in_admin_status_list' => true, 'show_in_admin_all_list'=> true, 'exclude_from_search'=> false));
        register_post_status('wc-eos-accepted', array('label'=> 'Accepted', 'public' => true, 'show_in_admin_status_list' => true, 'show_in_admin_all_list'=> true, 'exclude_from_search'=> false));
        register_post_status('wc-eos-rejected', array('label'=> 'Rejected', 'public' => true, 'show_in_admin_status_list' => true, 'show_in_admin_all_list'=> true, 'exclude_from_search'=> false));
        register_post_status('wc-eos-cancelled', array('label'=> 'Cancelled', 'public' => true, 'show_in_admin_status_list' => true, 'show_in_admin_all_list'=> true, 'exclude_from_search'=> false));
        register_post_status('wc-eos-completed', array('label'=> 'Completed', 'public' => true, 'show_in_admin_status_list' => true, 'show_in_admin_all_list'=> true, 'exclude_from_search'=> false));
        register_post_status('wc-eos-invoiced', array('label'=> 'Invoiced', 'public' => true, 'show_in_admin_status_list' => true, 'show_in_admin_all_list'=> true, 'exclude_from_search'=> false));
    }
    
    function sakamari_add_extra_order_statuses( $order_statuses ) {
        $new_order_statuses = array();
        foreach ($order_statuses as $key => $status) {
            $new_order_statuses[$key] = $status;
            $new_order_statuses['wc-eos-submitted'] = 'Submitted';
            $new_order_statuses['wc-eos-paid'] = 'Paid';
            $new_order_statuses['wc-eos-violated'] = 'Violated';
            $new_order_statuses['wc-eos-accepted'] = 'Accepted';
            $new_order_statuses['wc-eos-rejected'] = 'Rejected';
            $new_order_statuses['wc-eos-cancelled'] = 'Cancelled';
            $new_order_statuses['wc-eos-completed'] = 'Completed';
            $new_order_statuses['wc-eos-invoiced'] = 'Invoiced';
        }
        return $new_order_statuses;
    }
	
	add_action('admin_menu', 'sakamari_do_admin_init');
    add_action('admin_post_sakamari_registration_form', 'handle_submit_sakamari_registration_form');
    add_action('admin_post_sakamari_navigation_form', 'handle_submit_sakamari_navigation_form');
    add_action('woocommerce_init', 'sakamari_woocommerce_init', 10, 1); 
    add_action('init', 'sakamari_register_extra_order_status');
    add_action('in_admin_header', function () {
        remove_all_actions('admin_notices');
        remove_all_actions('all_admin_notices');
    }, 1000);
        
    add_filter('rest_authentication_errors', 'sakamari_json_basic_auth_error');
    add_filter('determine_current_user', 'sakamari_json_basic_auth_handler', 20);
    add_filter('woocommerce_rest_allowed_image_mime_types', 'sakamari_more_mimes_to_exts');
    add_filter('wc_order_statuses', 'sakamari_add_extra_order_statuses');
        
	function sakamari_more_mimes_to_exts($mime_to_ext){
		$mime_to_ext['webp'] = 'image/webp';
		return $mime_to_ext;
	}
