<!doctype html>
<html lang="en">
	<?php wp_head(); ?>
	<?php 
    	$dr = plugin_basename(__FILE__);
    	$drarr = explode('/', $dr);
    	$plugin_dir_name = $drarr[0];
	?>
	<style type="text/css">
    	  html.wp-toolbar {
    	      margin-top: 0px !important;
    	      padding-top : 0px important;
    	  }
    	  .wp-submenu {
    	      margin-left: 0px !important;
    	  }
	</style>
	<script>
    	var oc = '<?php echo esc_attr($org->code); ?>';
    	var pc = '<?php echo esc_attr($profile->code); ?>';
    	var uid = '<?php echo esc_attr($user->id); ?>';
    	var sid = '<?php echo esc_attr($site->id); ?>';
    	var sname = '<?php echo esc_attr($site->site_name); ?>';
    	
	 	function integrate(){
			var wcckey = $('#woocommerce_consumer_key').val().trim();
			var wcsec = $('#woocommerce_consumer_secret').val().trim();
			if(wcckey == ""){
				$('#woocommerce_consumer_key').addClass('is-invalid');
				return false;
			}else{
				$('#woocommerce_consumer_key').removeClass('is-invalid');
			}
			if(wcsec == ""){
				$('#woocommerce_consumer_secret').addClass('is-invalid');
				return false;
			}else{
				$('#woocommerce_consumer_secret').removeClass('is-invalid');
			}
			NProgress.start();
			var pdata = {'oc': oc,'pc': pc, 'sid' : sid, 
					'woocommerce_consumer_key': wcckey, 'woocommerce_consumer_secret': wcsec};
	    	var postUrl = "https://sitexapi.pearnode.com/sakamari/plugin/woocommerce.php";
	    	console.log("Woocommerce integrate data [" + JSON.stringify(pdata) + "]");
	    	$.post(postUrl, JSON.stringify(pdata), function(data) {
		    	NProgress.done();
	    		showMessage('Congratulations !!', 'Your site Woocommerce is now integrated using Sakamari', 'success');
	    	});
		    return false;
		}
	</script>
	
	<body style="overflow-x:hidden;">
		<div class="row w-100 m-0 p-2">
        	<div class="card-header bg-light w-100 mt-2" style="font-weight: bold;">
        		Integrate Woocommerce with Sakamari
        	</div>
        	<div class="card-body w-100 p-1 mt-1">
        		<div class="row w-100 m-0 mb-2 mt-1">
        			<div class="col-5 p-0">
        				<img src="<?php echo esc_attr(plugins_url()."/".$plugin_dir_name."/includes/assets/"); ?>images/woocommerce.png" 
        					class="shadow shadow-sm rounded w-100" 
        					style="height: 40vh;border-radius: 16px; "/>
        			</div>
        			<div class="col-7">
                          <h4>Steps to enable Woocommerce with Sakamari</h4>
                          <ol>
                              <li class="p-1">Goto Menu > Woocommerce > Settings > Advanced > REST API</li>
                              <li class="p-1">Click on the Add key button</li>
                              <li class="p-1">Enter description as "Sakamari Woocommerce"</li>
                              <li class="p-1">Change Permission to "Read / Write"</li>
                              <li class="p-1">Click on "Generate API Key" button</li>
                              <li class="p-1">Copy the "Consumer Key" and "Consumer Secret" paste it below</li>
                          </ol>
        			</div>
        		</div>
        		<div class="form-group mt-1">
        		    <label for="woocommerce_consumer_key"><b>Woocommerce Consumer Key</b></label>
        		    <input type="text" class="form-control" id="woocommerce_consumer_key" name="woocommerce_consumer_key" 
        		    	required="required"  value="<?php echo esc_attr($wc_consumer_key);?>"/>
        	    	<small id="wcckeyhelp" class="form-text text-muted">Enter the woocommerce Consumer Key you generated here</small>
        		</div>
        		<div class="form-group mt-1">
        		    <label for="woocommerce_consumer_secret"><b>Woocommerce Consumer Secret</b></label>
        		    <input type="text" class="form-control" id="woocommerce_consumer_secret" name="woocommerce_consumer_secret" 
        		    	required="required" value="<?php echo esc_attr($wc_consumer_secret);?>">
        	    	<small id="wccsechelp" class="form-text text-muted">Enter the woocommerce Consumer Secret you generated here</small>
        		</div>
        	</div>
        	<div class="card-footer w-100">
        		<button class="btn btn-primary w-100" onclick="return integrate();" style="background-color: blue !important;">
        			<b style="color: white;">Enable Woocommerce</b>
        		</button>
        	</div>
		</div>
	</body>
</html>